#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Voronoi RaymarchingMod01.fsh  by  rory618   
//https://www.shadertoy.com/view/ltK3DR
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels
uniform int       iFrame;  

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

vec3 hash33(vec3 p3)
{
	p3 = fract(p3 * vec3(.1031, .1030, .0973));
    p3 += dot(p3, p3.yxz+19.19);
    return fract(vec3((p3.x + p3.y)*p3.z, (p3.x+p3.z)*p3.y, (p3.y+p3.z)*p3.x));
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{  
	vec2 uv = ((fragCoord.xy+hash33(vec3(fragCoord.xy,iFrame)).xy)-iResolution.xy/2.) / iResolution.xx;
    vec3 p = iTime*vec3(.35, .47, .79)+vec3(iMouse.xy/50., .4);
    float l = .0;
    vec3 d = vec3(.36, .48, .80);
    vec3 r = vec3(0.48, -0.36, 0);
    vec3 rd = normalize(r*uv.x+cross(r,d)*uv.y + d*(1.-.6*iMouse.x/ iResolution.x));
    for(int i = 0; i < 40; i++){
        float closest = 1.;
        for(int nx = -1; nx < 1; nx++){
        for(int ny = -1; ny < 1; ny++){
        for(int nz = -1; nz < 1; nz++){
            vec3 np = ceil(p+l*rd) + vec3(nx,ny,nz);
            np += (hash33(np)-.5)*.8*smoothstep(-.5,.5,clamp(sin(.5*iTime),-.5,.5));
            closest = min(closest, length(p+l*rd-np));
            //Cubes:
            //closest = min(closest, dot(abs(p+l*rd-np),vec3(.5)));
        }
        }
        }
        l += .8*closest-(l+1.)/100.;
    }
    l=(l*l+5.)/(l+1.);
fragColor = texture2D(texture0,fragCoord/iResolution.xy);

	fragColor = .7*texture2D(texture0,fragCoord.xy/iResolution.xy) + .3*vec4(0.5+0.5*sin(l*vec3(.3,.4,.5)),1.0);


/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
gl_FragColor.a = length ( vec3(0.5) - gl_FragColor.rgb );
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

